 ; Ŀ
 ;   Min - realtime minsert editor.                                        
 ;   Copyright 1998 by Rocket Software                                     
 ;   A block which has more than one column or row can't be exploded.      
 ;                                                                         
 ;   Fortunately the explode command rarely damages nearby objects.        
 ; 

 ; Ŀ
 ;   Subroutine Zero - see if the edit box gave a callback because it      
 ;   was <Entered>, if so return the current string it contained and       
 ;   terminate the dialog box, else return nil and do nothing.             
 ; 
 (DEFUN ZERO ()
  (set_tile "rows" "0")
  (set_tile "columns" "0")
  (set_tile "rowdist" "0.00")
  (set_tile "coldist" "0.00"))
 ; Ŀ
 ;   Zero end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Rowsa - see if the edit box gave a callback because it     
 ;   was <Entered>, if so call editok, else see whether the various        
 ;   edit box values are appropriate.  Allows only Int edit box values.    
 ; 
 (DEFUN ROWSA (reason tile / nump typ)
  (if (= reason 1)
      (editok)
      (progn
           (setq nump (read (get_tile tile)))
           (setq typ (type nump))
           (cond ((= typ 'INT)
                  (set_tile "mintext" ""))
                 ((= typ 'REAL)
                  (set_tile "mintext" "Real truncated")
                  (set_tile tile (itoa (fix nump))))
                 (t
                   (set_tile tile "")
                   (set_tile "mintext" "Bad.")))
           ())))
 ; Ŀ
 ;   Rowsa end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Reala - see if the edit box gave a callback because it     
 ;   was <Entered>, if so call editok, else see whether the various        
 ;   edit box values are appropriate.                                      
 ; 
 (DEFUN REALA (reason tile / nump typ)
  (if (= reason 1)
      (editok)
      (progn
           (setq nump (read (get_tile tile)))
           (setq typ (type nump))
           (cond ((= typ 'INT)
                  (set_tile tile (rtos nump 2 2))
                  (set_tile "mintext" ""))
                 ((= typ 'REAL)
                  (set_tile "mintext" ""))
                 (t
                   (set_tile tile "")
                   (set_tile "mintext" "Bad.")))
           ())))
 ; Ŀ
 ;   Reala end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Editok - if OK was pressed, see if a valid string was      
 ;   present in each edit box, if so exit the dialog box and return the    
 ;   list of strings, otherwise show an error.                             
 ; 
 (DEFUN EDITOK (/ rowsp colsp rdistp cdistp nogo1 nogo2 nogo3 nogo4)
  (setq rowsp (read (get_tile "rows")))
  (setq atyp (type rowsp))
  (setq colsp (read (get_tile "columns")))
  (setq btyp (type colsp))
  (setq rdistp (read (get_tile "rowdist")))
  (setq ctyp (type rdistp))
  (setq cdistp (read (get_tile "coldist")))
  (setq dtyp (type cdistp))
  (cond ((= atyp 'INT) (setq nogo1 ()))
        ((= atyp 'REAL) (setq rowsp (fix rowsp)) (setq nogo1 ()))
        (t (set_tile "rows" "") (setq nogo1 t)))
  (cond ((= btyp 'INT) (setq nogo2 ()))
        ((= btyp 'REAL) (setq colsp (fix colsp)) (setq nogo2 ()))
        (t (set_tile "cols" "") (setq nogo2 t)))
  (cond ((= ctyp 'INT) (setq nogo3 ()))
        ((= ctyp 'REAL) (setq nogo3 ()))
        (t (set_tile "rowdist" "") (setq nogo3 t)))
  (cond ((= dtyp 'INT) (setq nogo4 ()))
        ((= dtyp 'REAL) (setq nogo4 ()))
        (t (set_tile "coldist" "") (setq nogo4 t)))
  (if (or nogo1 nogo2 nogo3 nogo4)
      (progn
           (set_tile "mintext" "Bad.")
           ())
      (progn
           (done_dialog)
           (list cdistp rdistp rowsp colsp))))
 ; Ŀ
 ;   Editok end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Spy - call a dialog box to deal with a text string.        
 ; 
 (DEFUN SPY (blnam xdist ydist rows cols /)
  (setq dcl_id (load_dialog "Min.dcl"))
  (new_dialog "min" dcl_id)            ; must come before data for box
  (action_tile "edit_ok" "(setq minlst (editok))")
  (action_tile "zero" "(zero)")
  (action_tile "rows" "(setq minlst (rowsa $reason \"rows\"))")
  (action_tile "columns" "(setq minlst (rowsa $reason \"columns\"))")
  (action_tile "rowdist" "(setq minlst (reala $reason \"rowdist\"))")
  (action_tile "coldist" "(setq minlst (reala $reason \"coldist\"))")
  (set_tile "min" blnam)
  (set_tile "rows" (itoa rows))
  (set_tile "columns" (itoa cols))
  (set_tile "rowdist" (rtos ydist 2 2))
  (set_tile "coldist" (rtos xdist 2 2))
  (start_dialog)
  (unload_dialog dcl_id)
 minlst)
 ; Ŀ
 ;   Spy end.                                                              
 ; 

 ; Ŀ
 ;   Min.                                                                  
 ; 
 (DEFUN C:MIN (/ enam typ str outer cc nn depth)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (if (and (setq enam (entsel "Select dah block: "))
           (setq enam (car enam))
           (setq entt (entget enam))
           (setq typ (cdr (assoc 0 entt)))
           (= "INSERT" typ))
      (progn
           (setq blnam (cdr (assoc 2 entt)))
           (setq xdist (cdr (setq asoc44 (assoc 44 entt))))
           (setq ydist (cdr (setq asoc45 (assoc 45 entt))))
           (setq cols (cdr (setq asoc70 (assoc 70 entt))))
           (setq rows (cdr (setq asoc71 (assoc 71 entt))))
           (if (setq minim (spy blnam xdist ydist rows cols))
               (progn
                    (setq xdist (nth 0 minim))
                    (setq ydist (nth 1 minim))
                    (setq rows (nth 2 minim))
                    (setq cols (nth 3 minim))
                    (setq entt (subst (cons 44 xdist) asoc44 entt))
                    (setq entt (subst (cons 45 ydist) asoc45 entt))
                    (setq entt (subst (cons 70 cols) asoc70 entt))
                    (setq entt (subst (cons 71 rows) asoc71 entt))
                    (entmod entt)))))
 (princ))